<?php defined('SYSPATH') or die('No direct script access.');

class Rename_post_to_query_in_logs_table extends Migration
{
    public $schema = 'public';
    public $table = 'logs';

    public function up()
    {
        $this->rename_column($this->table, 'post', 'query', null);
        
        $logs = ORM::factory('Log')->find_all();
        foreach($logs as $log)
        {
            $query = json_decode($log->query);
            if (isset($query->locations)) {
                $query->locations = array_map(['Task_Helper', 'locationToStr'], $query->locations);
                $log->query = json_encode($query);
                $log->save();
            }
        }
    }

    public function down()
    {
        $logs = ORM::factory('Log')->find_all();
        foreach($logs as $log)
        {
            $query = json_decode($log->query);
            if (isset($query->locations)) {
                $query->locations = array_map(['Task_Helper', 'locationToInt'], $query->locations);
                $log->query = json_encode($query);
                $log->save();
            }
        }
        
        $this->rename_column($this->table, 'query', 'post', null);
    }
}
